# GWECODE Admin Dashboard

## Overview
The GWECODE Admin Dashboard provides secure administrative control over your platform. This interface allows you to manage client domains, monitor verification activity, and control access to GWECODE services.

## Installation

### Upload Files
Upload all files from this package to your server at the path `/var/www/gwecode.com/admin/` or your web root directory plus `/admin/`.

### Create Authentication Password
SSH into your server and navigate to the admin directory. Run the following command to create your admin password:

```bash
cd /var/www/gwecode.com/admin/
htpasswd -c .htpasswd admin
```

You will be prompted to enter and confirm a secure password. This password protects access to the GWECODE admin dashboard.

### Configure Authentication Path
Edit the `.htaccess` file and update the AuthUserFile directive to match your server's actual directory path. The line should reflect your complete server path to the .htpasswd file.

### Set File Permissions
Execute these commands to ensure proper security permissions:

```bash
chmod 644 .htpasswd
chmod 644 .htaccess
chmod 644 *.php
chmod 755 .
```

### Access Dashboard
Navigate to https://gwecode.com/admin/ in your web browser. You will be prompted for authentication credentials. Enter username "admin" and the password you created previously.

## Security Features

The GWECODE admin dashboard implements multiple security layers. HTTP Basic Authentication via .htaccess prevents unauthorized access to the admin interface. The database file is protected from direct HTTP access through htaccess rules. Sensitive PHP files including database connection scripts are blocked from direct browser access. All administrative operations require proper authentication credentials.

## First Time Setup

Upon your first successful login, the system will automatically create the GWECODE database. You can immediately begin adding client domains to the platform. The dashboard provides real-time statistics showing total domains, active domains, awaiting activation, and inactive domains.

## Managing Domains

To add a new domain to GWECODE, click the Add Domain button in the dashboard navigation. Enter either an exact domain like example.com or a wildcard pattern like *.example.com to match all subdomains. The domain will be created with awaiting_activation status and will automatically transition to active when a client website first connects and verifies successfully.

To control domain access, use the toggle switches on each domain card in the dashboard. Domains in awaiting_activation status cannot be toggled until after first verification. Active domains can be toggled to inactive to temporarily disable access. Inactive domains can be toggled back to active to restore access.

## Monitoring Activity

The dashboard displays comprehensive metrics for each registered domain including total verification attempts, last verification timestamp, and current status. Statistics cards at the top of the dashboard provide an at-a-glance overview of your entire GWECODE platform including total registered domains and breakdown by status.

## Database Management

The GWECODE database is stored as gwecode.db in the admin directory. This SQLite database contains all domain registrations, verification history, and platform configuration. You should implement regular backups of this file to prevent data loss. The database is protected from direct HTTP access by htaccess rules for security.

## Changing Admin Password

To update your admin password at any time, run the htpasswd command again from the admin directory. This overwrites the existing password while preserving the admin username.

## Troubleshooting

If you experience repeated authentication prompts without being able to log in, verify that the AuthUserFile path in .htaccess matches your actual server directory structure. Confirm that the .htpasswd file was created successfully and has proper read permissions.

If you encounter database errors, ensure that SQLite support is enabled in your PHP installation. Verify that the admin directory has write permissions allowing the web server to create the database file. Review your server's PHP error logs for detailed error messages.

If the dashboard displays correctly but domain operations fail, check that all API files are present and have correct permissions. Verify that the database.php file is accessible to other PHP scripts in the directory.
