<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>GweCode Admin Dashboard</title>
    <style>
        * { margin: 0; padding: 0; box-sizing: border-box; }
        body { font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', 'Roboto', sans-serif; -webkit-font-smoothing: antialiased; }
        .app { min-height: 100vh; background: linear-gradient(135deg, #0f172a 0%, #581c87 50%, #0f172a 100%); position: relative; }
        .bg-pattern { position: absolute; inset: 0; opacity: 0.3; background-image: url('data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iNjAiIGhlaWdodD0iNjAiIHZpZXdCb3g9IjAgMCA2MCA2MCIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj48ZyBmaWxsPSJub25lIiBmaWxsLXJ1bGU9ImV2ZW5vZGQiPjxnIGZpbGw9IiNmZmYiIGZpbGwtb3BhY2l0eT0iMC4wMiI+PHBhdGggZD0iTTM2IDM0djItaDJ2LTJoLTJ6bTAtNGgydjJoLTJ2LTJ6bTAtNGgydjJoLTJ2LTJ6bTAtNGgydjJoLTJ2LTJ6bTAtNGgydjJoLTJ2LTJ6bTAtNGgydjJoLTJ2LTJ6bTAtNGgydjJoLTJ2LTJ6bTAtNGgydjJoLTJ2LTJ6bTAtNGgydjJoLTJ2LTJ6bS0yIDBoMnYyaC0ydi0yem0wIDRoMnYyaC0ydi0yem0wIDRoMnYyaC0ydi0yem0wIDRoMnYyaC0ydi0yem0wIDRoMnYyaC0ydi0yem0wIDRoMnYyaC0ydi0yem0wIDRoMnYyaC0ydi0yem0wIDRoMnYyaC0ydi0yem0wIDRoMnYyaC0ydi0yem0tMiAwaDJ2MmgtMnYtMnptMC00aDJ2MmgtMnYtMnptMC00aDJ2MmgtMnYtMnptMC00aDJ2MmgtMnYtMnptMC00aDJ2MmgtMnYtMnptMC00aDJ2MmgtMnYtMnptMC00aDJ2MmgtMnYtMnptMC00aDJ2MmgtMnYtMnptMC00aDJ2MmgtMnYtMnoiLz48L2c+PC9nPjwvc3ZnPg=='); }
        nav { position: relative; z-index: 10; border-bottom: 1px solid rgba(255, 255, 255, 0.1); backdrop-filter: blur(12px); background: rgba(255, 255, 255, 0.05); }
        .nav-content { max-width: 1400px; margin: 0 auto; padding: 1rem 1.5rem; display: flex; align-items: center; justify-content: space-between; }
        .logo-section { display: flex; align-items: center; gap: 0.75rem; }
        .logo { width: 40px; height: 40px; border-radius: 12px; background: linear-gradient(135deg, #a855f7 0%, #ec4899 100%); display: flex; align-items: center; justify-content: center; }
        .logo svg { width: 24px; height: 24px; color: white; }
        h1 { font-size: 1.5rem; font-weight: bold; color: white; }
        .nav-buttons { display: flex; gap: 0.5rem; }
        .nav-button { padding: 0.5rem 1rem; border-radius: 8px; border: none; cursor: pointer; font-size: 0.875rem; font-weight: 500; transition: all 0.2s; background: transparent; }
        .nav-button.active { background: rgba(255, 255, 255, 0.2); color: white; }
        .nav-button:not(.active) { color: rgba(255, 255, 255, 0.6); }
        .nav-button:not(.active):hover { color: white; background: rgba(255, 255, 255, 0.1); }
        main { position: relative; z-index: 10; max-width: 1400px; margin: 0 auto; padding: 3rem 1.5rem; }
        .view { display: none; }
        .view.active { display: block; }
        .header-section { display: flex; justify-content: space-between; align-items: start; margin-bottom: 2rem; }
        .header-text h2 { font-size: 1.875rem; font-weight: bold; color: white; margin-bottom: 0.5rem; }
        .header-text p { color: rgba(255, 255, 255, 0.6); }
        .btn { padding: 0.75rem 1.5rem; border-radius: 12px; border: none; cursor: pointer; font-size: 0.875rem; font-weight: 500; transition: all 0.2s; display: inline-flex; align-items: center; gap: 0.5rem; }
        .btn-primary { background: linear-gradient(135deg, #9333ea 0%, #ec4899 100%); color: white; }
        .btn-primary:hover { background: linear-gradient(135deg, #7e22ce 0%, #db2777 100%); }
        .btn-secondary { background: rgba(255, 255, 255, 0.1); backdrop-filter: blur(4px); border: 1px solid rgba(255, 255, 255, 0.2); color: white; }
        .btn-secondary:hover { background: rgba(255, 255, 255, 0.2); }
        .btn:disabled { opacity: 0.5; cursor: not-allowed; }
        .stats-grid { display: grid; grid-template-columns: repeat(auto-fit, minmax(240px, 1fr)); gap: 1.5rem; margin-bottom: 2rem; }
        .stat-card { background: rgba(255, 255, 255, 0.05); backdrop-filter: blur(12px); border: 1px solid rgba(255, 255, 255, 0.1); border-radius: 16px; padding: 1.5rem; }
        .stat-header { display: flex; justify-content: space-between; align-items: center; margin-bottom: 0.5rem; }
        .stat-header h3 { font-size: 0.875rem; font-weight: 500; color: rgba(255, 255, 255, 0.6); }
        .stat-icon { width: 40px; height: 40px; border-radius: 8px; display: flex; align-items: center; justify-content: center; }
        .stat-icon.blue { background: rgba(59, 130, 246, 0.2); }
        .stat-icon.green { background: rgba(34, 197, 94, 0.2); }
        .stat-icon.yellow { background: rgba(234, 179, 8, 0.2); }
        .stat-icon.red { background: rgba(239, 68, 68, 0.2); }
        .stat-icon svg { width: 20px; height: 20px; }
        .stat-icon.blue svg { color: #60a5fa; }
        .stat-icon.green svg { color: #4ade80; }
        .stat-icon.yellow svg { color: #facc15; }
        .stat-icon.red svg { color: #f87171; }
        .stat-value { font-size: 2.25rem; font-weight: bold; color: white; }
        .card { background: rgba(255, 255, 255, 0.05); backdrop-filter: blur(12px); border: 1px solid rgba(255, 255, 255, 0.1); border-radius: 16px; overflow: hidden; }
        .card-header { padding: 1.5rem; border-bottom: 1px solid rgba(255, 255, 255, 0.1); }
        .card-header h3 { font-size: 1.25rem; font-weight: 600; color: white; }
        .card-body { padding: 3rem; text-align: center; }
        .loading-spinner { display: inline-block; width: 48px; height: 48px; border: 4px solid rgba(255, 255, 255, 0.2); border-top-color: white; border-radius: 50%; animation: spin 1s linear infinite; }
        @keyframes spin { to { transform: rotate(360deg); } }
        .empty-state { color: rgba(255, 255, 255, 0.6); margin-top: 1rem; }
        .domains-grid { display: grid; gap: 1rem; padding: 1.5rem; }
        .domain-card { background: rgba(255, 255, 255, 0.03); border: 1px solid rgba(255, 255, 255, 0.1); border-radius: 12px; padding: 1.5rem; display: grid; grid-template-columns: auto 1fr auto auto; gap: 1.5rem; align-items: center; transition: all 0.2s; }
        .domain-card:hover { background: rgba(255, 255, 255, 0.05); border-color: rgba(255, 255, 255, 0.2); }
        .domain-icon { width: 56px; height: 56px; border-radius: 12px; display: flex; align-items: center; justify-content: center; background: linear-gradient(135deg, #a855f7 0%, #ec4899 100%); flex-shrink: 0; }
        .domain-icon svg { width: 28px; height: 28px; color: white; }
        .domain-info { min-width: 0; }
        .domain-name { font-size: 1.125rem; font-weight: 600; color: white; margin-bottom: 0.5rem; display: flex; align-items: center; gap: 0.5rem; }
        .wildcard-badge { display: inline-flex; align-items: center; gap: 0.25rem; padding: 0.125rem 0.5rem; background: rgba(168, 85, 247, 0.2); border: 1px solid rgba(168, 85, 247, 0.3); border-radius: 6px; font-size: 0.75rem; font-weight: 600; color: #a78bfa; text-transform: uppercase; letter-spacing: 0.5px; }
        .wildcard-badge svg { width: 12px; height: 12px; }
        .domain-meta { display: flex; gap: 1.5rem; flex-wrap: wrap; }
        .meta-item { display: flex; align-items: center; gap: 0.5rem; font-size: 0.875rem; color: rgba(255, 255, 255, 0.6); }
        .meta-item svg { width: 16px; height: 16px; color: rgba(255, 255, 255, 0.4); }
        .domain-stats { display: flex; gap: 2rem; padding: 0 1rem; border-left: 1px solid rgba(255, 255, 255, 0.1); border-right: 1px solid rgba(255, 255, 255, 0.1); }
        .stat-item { text-align: center; }
        .stat-item-label { font-size: 0.75rem; color: rgba(255, 255, 255, 0.5); text-transform: uppercase; letter-spacing: 0.05em; margin-bottom: 0.25rem; }
        .stat-item-value { font-size: 1.25rem; font-weight: 700; color: white; }
        .domain-controls { display: flex; flex-direction: column; align-items: flex-end; gap: 0.75rem; }
        .status-badge { display: inline-flex; align-items: center; gap: 0.5rem; padding: 0.375rem 0.875rem; border-radius: 9999px; font-size: 0.75rem; font-weight: 600; text-transform: uppercase; letter-spacing: 0.05em; }
        .status-badge.awaiting_activation { background: rgba(234, 179, 8, 0.15); color: #facc15; border: 1px solid rgba(234, 179, 8, 0.3); }
        .status-badge.active { background: rgba(34, 197, 94, 0.15); color: #4ade80; border: 1px solid rgba(34, 197, 94, 0.3); }
        .status-badge.inactive { background: rgba(239, 68, 68, 0.15); color: #f87171; border: 1px solid rgba(239, 68, 68, 0.3); }
        .status-dot { width: 6px; height: 6px; border-radius: 50%; animation: pulse 2s cubic-bezier(0.4, 0, 0.6, 1) infinite; }
        .status-badge.awaiting_activation .status-dot { background: #facc15; }
        .status-badge.active .status-dot { background: #4ade80; }
        .status-badge.inactive .status-dot { background: #f87171; }
        @keyframes pulse { 0%, 100% { opacity: 1; } 50% { opacity: 0.5; } }
        .toggle-switch { position: relative; width: 52px; height: 28px; background: rgba(239, 68, 68, 0.3); border-radius: 14px; cursor: pointer; transition: all 0.3s; border: 1px solid rgba(239, 68, 68, 0.5); }
        .toggle-switch.active { background: rgba(34, 197, 94, 0.3); border-color: rgba(34, 197, 94, 0.5); }
        .toggle-switch.awaiting { background: rgba(234, 179, 8, 0.3); border-color: rgba(234, 179, 8, 0.5); cursor: not-allowed; }
        .toggle-slider { position: absolute; top: 2px; left: 2px; width: 22px; height: 22px; background: white; border-radius: 50%; transition: all 0.3s; box-shadow: 0 2px 4px rgba(0, 0, 0, 0.2); }
        .toggle-switch.active .toggle-slider { transform: translateX(24px); }
        .form-group { margin-bottom: 1.5rem; }
        .form-label { display: block; font-size: 0.875rem; font-weight: 500; color: white; margin-bottom: 0.5rem; }
        .input-wrapper { position: relative; }
        .form-input { width: 100%; padding: 0.75rem 1rem; background: rgba(255, 255, 255, 0.05); border: 1px solid rgba(255, 255, 255, 0.2); border-radius: 12px; color: white; font-size: 0.875rem; transition: all 0.2s; }
        .form-input::placeholder { color: rgba(255, 255, 255, 0.4); }
        .form-input:focus { outline: none; border-color: #a855f7; box-shadow: 0 0 0 3px rgba(168, 85, 247, 0.1); }
        .input-icon { position: absolute; right: 1rem; top: 50%; transform: translateY(-50%); color: rgba(255, 255, 255, 0.4); pointer-events: none; }
        .input-icon svg { width: 20px; height: 20px; }
        .form-hint { margin-top: 0.5rem; font-size: 0.875rem; color: rgba(255, 255, 255, 0.4); }
        .info-box { background: rgba(59, 130, 246, 0.1); border: 1px solid rgba(59, 130, 246, 0.2); border-radius: 12px; padding: 1rem; margin-top: 1rem; }
        .info-box-title { display: flex; align-items: center; gap: 0.5rem; font-size: 0.875rem; font-weight: 600; color: #60a5fa; margin-bottom: 0.5rem; }
        .info-box-title svg { width: 16px; height: 16px; }
        .info-box-content { font-size: 0.875rem; color: rgba(255, 255, 255, 0.7); line-height: 1.6; }
        .info-box-examples { margin-top: 0.75rem; padding-top: 0.75rem; border-top: 1px solid rgba(59, 130, 246, 0.2); }
        .example-item { display: flex; align-items: start; gap: 0.5rem; margin-top: 0.5rem; font-size: 0.8125rem; }
        .example-item code { background: rgba(0, 0, 0, 0.2); padding: 0.125rem 0.375rem; border-radius: 4px; font-family: monospace; color: #a78bfa; }
        .alert { padding: 1rem; border-radius: 12px; margin-bottom: 1.5rem; display: flex; align-items: center; }
        .alert.error { background: rgba(239, 68, 68, 0.1); border: 1px solid rgba(239, 68, 68, 0.2); color: #f87171; }
        .alert.success { background: rgba(34, 197, 94, 0.1); border: 1px solid rgba(34, 197, 94, 0.2); color: #4ade80; }
        .alert svg { width: 20px; height: 20px; margin-right: 0.75rem; flex-shrink: 0; }
        .back-button { display: flex; align-items: center; gap: 0.5rem; color: rgba(255, 255, 255, 0.6); background: none; border: none; cursor: pointer; font-size: 0.875rem; margin-bottom: 1.5rem; transition: color 0.2s; }
        .back-button:hover { color: white; }
        .back-button svg { width: 20px; height: 20px; }
        @media (max-width: 1024px) {
            .domain-card { grid-template-columns: auto 1fr; }
            .domain-stats { grid-column: 1 / -1; border-left: none; border-right: none; border-top: 1px solid rgba(255, 255, 255, 0.1); padding: 1rem 0 0 0; margin-top: 1rem; justify-content: space-around; }
            .domain-controls { grid-column: 1 / -1; flex-direction: row; justify-content: space-between; align-items: center; border-top: 1px solid rgba(255, 255, 255, 0.1); padding-top: 1rem; margin-top: 1rem; }
        }
        @media (max-width: 768px) {
            .nav-content { flex-direction: column; gap: 1rem; }
            .stats-grid { grid-template-columns: 1fr; }
            .domain-card { grid-template-columns: 1fr; }
            .domain-icon { display: none; }
        }
    </style>
</head>
<body>
    <div class="app">
        <div class="bg-pattern"></div>
        
        <nav>
            <div class="nav-content">
                <div class="logo-section">
                    <div class="logo">
                        <svg fill="none" viewBox="0 0 24 24" stroke="currentColor">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 10V3L4 14h7v7l9-11h-7z" />
                        </svg>
                    </div>
                    <h1>GweCode Admin</h1>
                </div>
                
                <div class="nav-buttons">
                    <button class="nav-button active" onclick="showView('dashboard')">Dashboard</button>
                    <button class="nav-button" onclick="showView('create')">Add Domain</button>
                </div>
            </div>
        </nav>

        <main>
            <div id="dashboard-view" class="view active">
                <div class="header-section">
                    <div class="header-text">
                        <h2>Dashboard</h2>
                        <p>Manage all GweCode domains and monitor their status</p>
                    </div>
                    <button class="btn btn-secondary" onclick="loadKeys()">
                        <svg fill="none" viewBox="0 0 24 24" stroke="currentColor" style="width: 20px; height: 20px;">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 4v5h.582m15.356 2A8.001 8.001 0 004.582 9m0 0H9m11 11v-5h-.581m0 0a8.003 8.003 0 01-15.357-2m15.357 2H15" />
                        </svg>
                        Refresh
                    </button>
                </div>

                <div class="stats-grid">
                    <div class="stat-card">
                        <div class="stat-header">
                            <h3>Total Domains</h3>
                            <div class="stat-icon blue">
                                <svg fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M21 12a9 9 0 01-9 9m9-9a9 9 0 00-9-9m9 9H3m9 9a9 9 0 01-9-9m9 9c1.657 0 3-4.03 3-9s-1.343-9-3-9m0 18c-1.657 0-3-4.03-3-9s1.343-9 3-9m-9 9a9 9 0 019-9" />
                                </svg>
                            </div>
                        </div>
                        <div class="stat-value" id="total-keys">0</div>
                    </div>

                    <div class="stat-card">
                        <div class="stat-header">
                            <h3>Active</h3>
                            <div class="stat-icon green">
                                <svg fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z" />
                                </svg>
                            </div>
                        </div>
                        <div class="stat-value" id="active-keys">0</div>
                    </div>

                    <div class="stat-card">
                        <div class="stat-header">
                            <h3>Awaiting</h3>
                            <div class="stat-icon yellow">
                                <svg fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8v4l3 3m6-3a9 9 0 11-18 0 9 9 0 0118 0z" />
                                </svg>
                            </div>
                        </div>
                        <div class="stat-value" id="awaiting-keys">0</div>
                    </div>

                    <div class="stat-card">
                        <div class="stat-header">
                            <h3>Inactive</h3>
                            <div class="stat-icon red">
                                <svg fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M18.364 18.364A9 9 0 005.636 5.636m12.728 12.728A9 9 0 015.636 5.636m12.728 12.728L5.636 5.636" />
                                </svg>
                            </div>
                        </div>
                        <div class="stat-value" id="inactive-keys">0</div>
                    </div>
                </div>

                <div class="card">
                    <div class="card-header">
                        <h3>All Domains</h3>
                    </div>
                    <div id="domains-container"></div>
                </div>
            </div>

            <div id="create-view" class="view">
                <button class="back-button" onclick="showView('dashboard')">
                    <svg fill="none" viewBox="0 0 24 24" stroke="currentColor">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M10 19l-7-7m0 0l7-7m-7 7h18" />
                    </svg>
                    Back to Dashboard
                </button>

                <div class="header-text" style="margin-bottom: 1.5rem;">
                    <h2>Add Domain</h2>
                    <p>Register a new domain or wildcard pattern to GweCode</p>
                </div>

                <div class="card" style="max-width: 48rem; margin: 0 auto;">
                    <div style="padding: 2rem;">
                        <form id="create-form" onsubmit="createDomain(event)">
                            <div class="form-group">
                                <label class="form-label" for="domain">Domain or Pattern</label>
                                <div class="input-wrapper">
                                    <input type="text" id="domain" class="form-input" placeholder="example.com or *.example.com" required>
                                    <div class="input-icon">
                                        <svg fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M21 12a9 9 0 01-9 9m9-9a9 9 0 00-9-9m9 9H3m9 9a9 9 0 01-9-9m9 9c1.657 0 3-4.03 3-9s-1.343-9-3-9m0 18c-1.657 0-3-4.03-3-9s1.343-9 3-9m-9 9a9 9 0 019-9" />
                                        </svg>
                                    </div>
                                </div>
                                <p class="form-hint">Enter a domain or use wildcards for subdomains</p>
                                
                                <div class="info-box">
                                    <div class="info-box-title">
                                        <svg fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 16h-1v-4h-1m1-4h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z" />
                                        </svg>
                                        Wildcard Subdomain Support
                                    </div>
                                    <div class="info-box-content">
                                        Use an asterisk wildcard to match all subdomains under a domain. This is useful for testing environments, multi-tenant applications, or when you have multiple subdomains that should all be authorized.
                                        
                                        <div class="info-box-examples">
                                            <div class="example-item">
                                                <span>•</span>
                                                <span><code>*.example.com</code> will match <code>app.example.com</code>, <code>test.example.com</code>, <code>api.example.com</code> and any other subdomain</span>
                                            </div>
                                            <div class="example-item">
                                                <span>•</span>
                                                <span><code>example.com</code> will match only the exact domain (no subdomains)</span>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div id="error-container"></div>
                            <div id="success-container"></div>

                            <button type="submit" class="btn btn-primary" style="width: 100%;" id="create-btn">
                                <svg fill="none" viewBox="0 0 24 24" stroke="currentColor" style="width: 20px; height: 20px;">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 6v6m0 0v6m0-6h6m-6 0H6" />
                                </svg>
                                Add Domain
                            </button>
                        </form>
                    </div>
                </div>
            </div>
        </main>
    </div>

    <script>
        let allKeys = [];
        function showView(viewName) {
            document.querySelectorAll('.view').forEach(v => v.classList.remove('active'));
            document.querySelectorAll('.nav-button').forEach(b => b.classList.remove('active'));
            document.getElementById(viewName + '-view').classList.add('active');
            event.target.classList.add('active');
            if (viewName === 'dashboard') { loadKeys(); } 
            else if (viewName === 'create') { 
                document.getElementById('create-form').reset();
                document.getElementById('error-container').innerHTML = '';
                document.getElementById('success-container').innerHTML = '';
            }
        }
        async function loadKeys() {
            const container = document.getElementById('domains-container');
            container.innerHTML = '<div class="card-body"><div class="loading-spinner"></div><p class="empty-state">Loading domains...</p></div>';
            try {
                const response = await fetch('admin-api.php?action=keys');
                const data = await response.json();
                if (data.success) { allKeys = data.keys; updateStats(); renderDomains(); }
            } catch (error) { container.innerHTML = '<div class="card-body"><p style="color: #f87171;">Failed to load domains</p></div>'; }
        }
        function updateStats() {
            document.getElementById('total-keys').textContent = allKeys.length;
            document.getElementById('active-keys').textContent = allKeys.filter(k => k.status === 'active').length;
            document.getElementById('awaiting-keys').textContent = allKeys.filter(k => k.status === 'awaiting_activation').length;
            document.getElementById('inactive-keys').textContent = allKeys.filter(k => k.status === 'inactive').length;
        }
        function renderDomains() {
            const container = document.getElementById('domains-container');
            if (allKeys.length === 0) {
                container.innerHTML = '<div class="card-body"><svg style="width: 64px; height: 64px; color: rgba(255, 255, 255, 0.2); margin: 0 auto 1rem;" fill="none" viewBox="0 0 24 24" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M21 12a9 9 0 01-9 9m9-9a9 9 0 00-9-9m9 9H3m9 9a9 9 0 01-9-9m9 9c1.657 0 3-4.03 3-9s-1.343-9-3-9m0 18c-1.657 0-3-4.03-3-9s1.343-9 3-9m-9 9a9 9 0 019-9" /></svg><p class="empty-state">No domains added yet</p></div>';
                return;
            }
            const domainsHTML = '<div class="domains-grid">' + allKeys.map(key => `
                <div class="domain-card">
                    <div class="domain-icon"><svg fill="none" viewBox="0 0 24 24" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M21 12a9 9 0 01-9 9m9-9a9 9 0 00-9-9m9 9H3m9 9a9 9 0 01-9-9m9 9c1.657 0 3-4.03 3-9s-1.343-9-3-9m0 18c-1.657 0-3-4.03-3-9s1.343-9 3-9m-9 9a9 9 0 019-9" /></svg></div>
                    <div class="domain-info">
                        <div class="domain-name">${key.domain}${key.domain.startsWith('*.') ? '<span class="wildcard-badge"><svg fill="none" viewBox="0 0 24 24" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M11.049 2.927c.3-.921 1.603-.921 1.902 0l1.519 4.674a1 1 0 00.95.69h4.915c.969 0 1.371 1.24.588 1.81l-3.976 2.888a1 1 0 00-.363 1.118l1.518 4.674c.3.922-.755 1.688-1.538 1.118l-3.976-2.888a1 1 0 00-1.176 0l-3.976 2.888c-.783.57-1.838-.197-1.538-1.118l1.518-4.674a1 1 0 00-.363-1.118l-3.976-2.888c-.784-.57-.38-1.81.588-1.81h4.914a1 1 0 00.951-.69l1.519-4.674z" /></svg>Wildcard</span>' : ''}</div>
                        <div class="domain-meta">
                            <div class="meta-item"><svg fill="none" viewBox="0 0 24 24" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 7V3m8 4V3m-9 8h10M5 21h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v12a2 2 0 002 2z" /></svg>Added ${formatDateShort(key.created_at)}</div>
                            ${key.last_verified ? '<div class="meta-item"><svg fill="none" viewBox="0 0 24 24" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8v4l3 3m6-3a9 9 0 11-18 0 9 9 0 0118 0z" /></svg>Last verified ' + formatDateShort(key.last_verified) + '</div>' : ''}
                        </div>
                    </div>
                    <div class="domain-stats"><div class="stat-item"><div class="stat-item-label">Verifications</div><div class="stat-item-value">${key.verification_count || 0}</div></div></div>
                    <div class="domain-controls">
                        <span class="status-badge ${key.status}"><span class="status-dot"></span>${key.status.replace('_', ' ')}</span>
                        <div class="toggle-switch ${key.status === 'active' ? 'active' : ''} ${key.status === 'awaiting_activation' ? 'awaiting' : ''}" onclick="${key.status !== 'awaiting_activation' ? `toggleStatus(${key.id}, '${key.status}')` : ''}" title="${key.status === 'awaiting_activation' ? 'Cannot toggle until first verification' : 'Toggle active/inactive'}"><div class="toggle-slider"></div></div>
                    </div>
                </div>
            `).join('') + '</div>';
            container.innerHTML = domainsHTML;
        }
        function formatDateShort(dateString) {
            const date = new Date(dateString); const now = new Date(); const diff = now - date; const days = Math.floor(diff / (1000 * 60 * 60 * 24));
            if (days === 0) return 'today'; if (days === 1) return 'yesterday'; if (days < 7) return `${days} days ago`; if (days < 30) return `${Math.floor(days / 7)} weeks ago`;
            return date.toLocaleDateString('en-US', { month: 'short', day: 'numeric', year: date.getFullYear() !== now.getFullYear() ? 'numeric' : undefined });
        }
        async function toggleStatus(id, currentStatus) {
            try {
                const response = await fetch('admin-api.php?action=toggle', { method: 'POST', headers: { 'Content-Type': 'application/json', }, body: JSON.stringify({ id }) });
                const data = await response.json();
                if (data.success) { loadKeys(); }
            } catch (error) { console.error('Failed to toggle status'); }
        }
        async function createDomain(event) {
            event.preventDefault();
            const domain = document.getElementById('domain').value; const btn = document.getElementById('create-btn');
            const errorContainer = document.getElementById('error-container'); const successContainer = document.getElementById('success-container');
            errorContainer.innerHTML = ''; successContainer.innerHTML = ''; btn.disabled = true;
            btn.innerHTML = '<div class="loading-spinner" style="width: 20px; height: 20px; border-width: 2px;"></div>Adding...';
            try {
                const response = await fetch('admin-api.php?action=create', { method: 'POST', headers: { 'Content-Type': 'application/json', }, body: JSON.stringify({ domain }) });
                const data = await response.json();
                if (data.success) {
                    document.getElementById('create-form').reset(); const isWildcard = domain.startsWith('*.');
                    successContainer.innerHTML = '<div class="alert success"><svg fill="none" viewBox="0 0 24 24" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z" /></svg><span>' + (isWildcard ? 'Wildcard pattern' : 'Domain') + ' added successfully! It will activate automatically when a matching website first connects.</span></div>';
                    loadKeys(); setTimeout(() => { showView('dashboard'); }, 2000);
                } else { errorContainer.innerHTML = '<div class="alert error"><svg fill="none" viewBox="0 0 24 24" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8v4m0 4h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z" /></svg><span>' + data.error + '</span></div>'; }
            } catch (error) { errorContainer.innerHTML = '<div class="alert error"><svg fill="none" viewBox="0 0 24 24" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8v4m0 4h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z" /></svg><span>Network error. Please try again.</span></div>'; } 
            finally { btn.disabled = false; btn.innerHTML = '<svg fill="none" viewBox="0 0 24 24" stroke="currentColor" style="width: 20px; height: 20px;"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 6v6m0 0v6m0-6h6m-6 0H6" /></svg>Add Domain'; }
        }
        loadKeys();
    </script>
</body>
</html>
